/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import org.jetbrains.annotations.Nullable;
import team.chisel.ctm.client.CTMClient;
import team.chisel.ctm.client.resource.CTMMetadataReader;
import team.chisel.ctm.client.resource.CTMMetadataSection;

public class ResourceUtil {
    private static final Map<class_2960, CTMMetadataSection> METADATA_CACHE = new HashMap<class_2960, CTMMetadataSection>();

    public static Optional<class_3298> getResource(class_2960 identifier) {
        return class_310.method_1551().method_1478().method_14486(identifier);
    }

    @Nullable
    public static CTMMetadataSection getMetadata(class_2960 identifier) throws IOException {
        if (METADATA_CACHE.containsKey(identifier)) {
            return METADATA_CACHE.get(identifier);
        }
        CTMMetadataSection metadata = null;
        Optional<class_3298> resource = ResourceUtil.getResource(identifier);
        if (resource.isPresent()) {
            metadata = resource.get().method_14481().method_43041((class_3270)CTMMetadataReader.INSTANCE).map(ctmMetadataSection -> {
                METADATA_CACHE.put(identifier, (CTMMetadataSection)ctmMetadataSection);
                return ctmMetadataSection;
            }).orElse(null);
        }
        return metadata;
    }

    @Nullable
    public static CTMMetadataSection getMetadata(class_1058 sprite) throws IOException {
        return ResourceUtil.getMetadata(ResourceUtil.toTextureIdentifier(sprite.method_4598()));
    }

    @Nullable
    public static CTMMetadataSection getMetadataSafe(class_2960 identifier) {
        try {
            return ResourceUtil.getMetadata(identifier);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            CTMClient.LOGGER.error("Error loading metadata for resource " + identifier + ".", (Throwable)e);
        }
        return null;
    }

    @Nullable
    public static CTMMetadataSection getMetadataSafe(class_1058 sprite) {
        try {
            return ResourceUtil.getMetadata(sprite);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            CTMClient.LOGGER.error("Error loading metadata for sprite " + sprite.method_4598() + ".", (Throwable)e);
        }
        return null;
    }

    public static class_2960 toTextureIdentifier(class_2960 identifier) {
        Object path = identifier.method_12832();
        if (!((String)path).startsWith("textures/")) {
            path = "textures/" + (String)path;
        }
        if (!((String)path).endsWith(".png")) {
            path = (String)path + ".png";
        }
        return ((String)path).equals(identifier.method_12832()) ? identifier : new class_2960(identifier.method_12836(), (String)path);
    }

    public static void invalidateCaches() {
        METADATA_CACHE.clear();
    }
}

